/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control;

import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.categories.MusicCategories;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;

public class ResourcePackUtils {
    protected static final String RESOURCEPACK_PROFILE_NAME = "file/music_control";
    protected static Path RESOURCEPACK_PATH = null;
    protected static Path ASSETS_PATH = null;
    protected static boolean WAS_CREATED = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private ResourcePackUtils() {
    }

    public static boolean exists() {
        return class_310.method_1551().method_1520().method_29206().stream().anyMatch(name -> name.startsWith(RESOURCEPACK_PROFILE_NAME));
    }

    public static boolean wasCreatedOrIsEnabled() {
        return WAS_CREATED || class_310.method_1551().method_1520().method_29210().stream().anyMatch(name -> name.startsWith(RESOURCEPACK_PROFILE_NAME));
    }

    public static void writeConfig() {
        if (WAS_CREATED) {
            WAS_CREATED = false;
        } else if (RESOURCEPACK_PATH == null) {
            ResourcePackUtils.setPaths();
        }
        HashMap<String, FileWriter> fileWriters = new HashMap<String, FileWriter>();
        HashMap<String, JsonObject> jsonObjects = new HashMap<String, JsonObject>();
        for (String namespace2 : MusicCategories.NAMESPACES) {
            jsonObjects.put(namespace2, new JsonObject());
            try {
                fileWriters.put(namespace2, new FileWriter(ResourcePackUtils.getSoundPath(namespace2).toFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Music.MUSIC_BY_EVENT.forEach((eventId, musics) -> {
            JsonArray sounds = new JsonArray();
            for (Object music : musics) {
                JsonObject fileSound = new JsonObject();
                fileSound.addProperty("name", ((Music)music).getIdentifier().toString());
                fileSound.addProperty("stream", Boolean.valueOf(true));
                sounds.add((JsonElement)fileSound);
            }
            HashSet<class_2960> events = Music.EVENTS_OF_EVENT.get(eventId);
            if (events != null) {
                for (class_2960 otherEventId : events) {
                    JsonObject eventSound = new JsonObject();
                    eventSound.addProperty("name", otherEventId.method_12832());
                    eventSound.addProperty("type", "event");
                    sounds.add((JsonElement)eventSound);
                }
            }
            JsonObject soundEvent = new JsonObject();
            soundEvent.addProperty("category", "music");
            soundEvent.addProperty("replace", Boolean.valueOf(true));
            soundEvent.add("sounds", (JsonElement)sounds);
            ((JsonObject)jsonObjects.get(eventId.method_12836())).add(eventId.method_12832(), (JsonElement)soundEvent);
        });
        fileWriters.forEach((namespace, fileWriter) -> {
            try (PrintWriter out = new PrintWriter((Writer)fileWriter);){
                out.write(GSON.toJson((JsonElement)jsonObjects.get(namespace)));
                out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void createResourcePack() {
        String resourcePackProfileName = ResourcePackUtils.findNextAvailablePath();
        try {
            Files.createDirectories(RESOURCEPACK_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        ResourcePackUtils.createMetaFile();
        ResourcePackUtils.createIcon();
        try {
            Files.createDirectories(ASSETS_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (String namespace : MusicCategories.NAMESPACES) {
            Path namespacePath = ASSETS_PATH.resolve(namespace);
            try {
                Files.createDirectories(namespacePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        WAS_CREATED = true;
        class_310.method_1551().method_1520().method_14445();
        class_310.method_1551().method_1520().method_49427(resourcePackProfileName);
    }

    private static String findNextAvailablePath() {
        Object resourcePackName = "music_control";
        int i = 0;
        Path resourcePackDir = class_310.method_1551().method_1479();
        RESOURCEPACK_PATH = resourcePackDir.resolve((String)resourcePackName);
        while (Files.exists(RESOURCEPACK_PATH, new LinkOption[0])) {
            resourcePackName = "music_control_" + ++i;
            RESOURCEPACK_PATH = resourcePackDir.resolve((String)resourcePackName);
        }
        ASSETS_PATH = RESOURCEPACK_PATH.resolve("assets");
        return "file/" + (String)resourcePackName;
    }

    private static void setPaths() {
        Optional<String> selectedResourcePack = class_310.method_1551().method_1520().method_29210().stream().filter(name -> name.startsWith(RESOURCEPACK_PROFILE_NAME)).findFirst();
        selectedResourcePack.ifPresent(name -> {
            RESOURCEPACK_PATH = class_310.method_1551().method_1479().resolve(name.substring(5));
            ASSETS_PATH = RESOURCEPACK_PATH.resolve("assets");
        });
    }

    private static void createMetaFile() {
        Path path = RESOURCEPACK_PATH.resolve("pack.mcmeta");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                JsonObject data = new JsonObject();
                JsonObject pack = new JsonObject();
                pack.addProperty("pack_format", (Number)class_155.method_16673().method_48017(class_3264.field_14188));
                pack.addProperty("description", class_2561.method_43471((String)"music_control.metadata.description").getString());
                data.add("pack", (JsonElement)pack);
                try (PrintWriter out = new PrintWriter(new FileWriter(path.toFile()));){
                    out.write(GSON.toJson((JsonElement)data));
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void createIcon() {
        Optional iconPath;
        Path targetPath = RESOURCEPACK_PATH.resolve("pack.png");
        if (Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        Optional modContainer = FabricLoader.getInstance().getModContainer("music_control");
        if (modContainer.isPresent()) {
            iconPath = ((ModContainer)modContainer.get()).getMetadata().getIconPath(400);
            if (!iconPath.isPresent()) {
                return;
            }
        } else {
            return;
        }
        Optional sourcePath = ((ModContainer)modContainer.get()).findPath((String)iconPath.get());
        if (sourcePath.isEmpty()) {
            return;
        }
        try {
            Files.copy((Path)sourcePath.get(), targetPath, new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getSoundPath(String namespace) {
        Path dirPath = ASSETS_PATH.resolve(namespace);
        Path filePath = dirPath.resolve("sounds.json");
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath;
        }
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
            return Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

